'use strict';

/* --------------------------------------------------------------
 order_email_invoice.js 2016-12-08
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * This module handels the click event of the invoice email button
 *
 * @module Compatibility/order_email_invoice
 */
gx.compatibility.module('order_email_invoice', ['modal'],

/**  @lends module:Compatibility/order_email_invoice */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @var {object}
     */

    var $this = $(this);

    /**
     * Default Options
     *
     * @type {object}
     */
    var defaults = {};

    /**
     * Final Options
     *
     * @var {object}
     */
    var options = $.extend(true, {}, defaults, data);

    /**
     * Module Object
     *
     * @type {object}
     */
    var module = {};

    /**
     * On Email Invoice Click
     *
     * Display the email-invoice modal.
     */
    function _onEmailInvoiceClick() {
        var $modal = $('.email-invoice.modal');
        var url = jse.core.config.get('appUrl') + '/admin/admin.php';
        var data = {
            id: options.id,
            do: 'OrdersModalsAjax/GetEmailInvoiceSubject',
            pageToken: jse.core.config.get('pageToken')
        };
        var invoiceNumbersHtml = '';

        $modal.find('.customer-info').text('"' + options.name + '"');
        $modal.find('.email-address').val(options.email);

        $modal.data('orderId', options.id).modal('show');

        $.ajax({ url: url, data: data, dataType: 'json' }).done(function (response) {
            $modal.attr('data-gx-widget', 'single_checkbox');

            $modal.find('.subject').val(response.subject);
            if (response.invoiceIdExists) {
                $modal.find('.invoice-num-info').addClass('hidden');
                $modal.find('.no-invoice').removeClass('hidden');
            } else {
                $modal.find('.invoice-num-info').removeClass('hidden');
                $modal.find('.no-invoice').addClass('hidden');
            }

            if (Object.keys(response.invoiceNumbers).length <= 1) {
                $modal.find('.invoice-numbers').addClass('hidden');
            } else {
                $modal.find('.invoice-numbers').removeClass('hidden');
            }

            for (var invoiceId in response.invoiceNumbers) {
                invoiceNumbersHtml += '<p><input type="checkbox" name="invoice_ids[]" value="' + invoiceId + '" checked="checked" class="invoice-numbers-checkbox" /> ' + response.invoiceNumbers[invoiceId] + '</p>';
            }

            $modal.find('.invoice-numbers-checkboxes').html(invoiceNumbersHtml);

            $modal.find('.invoice-numbers-checkbox').on('change', _onChangeEmailInvoiceCheckbox);

            gx.widgets.init($modal);
        });
    }

    /**
     * On Email Invoice Checkbox Change
     *
     * Disable send button if all invoice number checkboxes are unchecked. Otherwise enable the send button again.
     */
    function _onChangeEmailInvoiceCheckbox() {
        var $modal = $('.email-invoice.modal');

        if ($modal.find('.invoice-numbers-checkbox').length > 0) {
            if ($modal.find('.invoice-numbers-checkbox:checked').length > 0) {
                $modal.find('.send').prop('disabled', false);
            } else {
                $modal.find('.send').prop('disabled', true);
            }
        } else {
            $modal.find('.send').prop('disabled', false);
        }
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('click', _onEmailInvoiceClick);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
